function showToast(message) {

    var toast = document.createElement('div');
    toast.classList.add('toast');
    toast.classList.add('show');
    toast.style.position = 'fixed';
    toast.style.top = '20px';
    toast.style.right = '20px';
    toast.style.zIndex = '1050';

    var toastBody = document.createElement('div');
    toastBody.classList.add('toast-body');
    toastBody.style.color = 'white'; // Asegura que el texto sea blanco
    toastBody.innerText = message;
    toast.appendChild(toastBody);

    document.body.appendChild(toast);

    setTimeout(function () {
        toast.classList.remove('show');
        setTimeout(function () {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}



function showDangerToast(message) {

    var toast = document.createElement('div');
    toast.classList.add('toast');
    toast.classList.add('show');
    toast.classList.add('bg-danger'); // Clase de Bootstrap para fondo rojo
    toast.style.position = 'fixed';
    toast.style.top = '20px';
    toast.style.right = '20px';
    toast.style.zIndex = '1050';

    var toastBody = document.createElement('div');
    toastBody.classList.add('toast-body');
    toastBody.style.color = 'white';
    toastBody.innerText = message;
    toast.appendChild(toastBody);

    document.body.appendChild(toast);

    setTimeout(function () {
        toast.classList.remove('show');
        setTimeout(function () {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}


function showPrimaryToast(message) {

    var toast = document.createElement('div');
    toast.classList.add('toast');
    toast.classList.add('show');
    toast.classList.add('bg-primary'); // Clase de Bootstrap para fondo rojo
    toast.style.position = 'fixed';
    toast.style.top = '20px';
    toast.style.right = '20px';
    toast.style.zIndex = '1050';

    var toastBody = document.createElement('div');
    toastBody.classList.add('toast-body');
    toastBody.style.color = 'white';
    toastBody.innerText = message;
    toast.appendChild(toastBody);

    document.body.appendChild(toast);

    setTimeout(function () {
        toast.classList.remove('show');
        setTimeout(function () {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}

async function postData(apiUrl, dataToSend) {
    return callApi(apiUrl, dataToSend, 'POST');
}

async function putData(apiUrl, dataToSend) {
    return callApi(apiUrl, dataToSend, 'PUT');
}


function getData(url) {
    return fetch(url)
        .then(response => {
            if (!response.ok) {
                throw new Error(`Error: ${response.status} - ${response.statusText}`);
            }
            return response.json();
        })
        .then(data => {
            //console.log('Datos obtenidos del servidor:', data);
            return data;
        })
        .catch(error => {
            //console.error('Error en la solicitud GET:', error.message);
            throw error; // Re-lanza el error para que pueda ser manejado por el código que llama a getData
        });
}


async function getDataAsync(apiUrl) {

    var data;

    try {

        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl);
        //console.log('Datos obtenidos: ', response);

        // Verificamos si la respuesta es exitosa (código de estado 2xx)
        if (!response.ok) {
            throw new Error(`Error: ${response.status} - ${response.statusText}`);
        }

        // Convertimos los datos a formato JSON y hacemos algo con ellos
        data = await response.json();

        //console.log('Datos obtenidos del servidor:', data);

    } catch (error) {
        // Manejamos cualquier error que pueda ocurrir durante la solicitud
        //console.error('Error en la solicitud GET:', error.message);
    }
    
    return data;
}

async function callApi(apiUrl, dataToSend, method) {
    var error = "";

    // Configuración de la solicitud
    const requestOptions = {
        method: method,
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(dataToSend)
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        const data = await response.json();

        //console.log('Respuesta del servidor:', data);

        if (status != 200) {
            error = "Error:  " + data.mensaje;
        }

        // Verificamos si la respuesta es exitosa (código de estado 2xx)
        // if (!response.ok) {
        //     throw new Error(`Error: ${response.mensaje}`);
        //     //throw new Error(`Error: ${response.status} - ${response.statusText}`);
        // }

    } catch (error) {
        error = error.message;
        // Manejamos cualquier error que pueda ocurrir durante la solicitud
        //console.error('Error en la solicitud:', error.message);
    }

    return error;
}


async function deleteData(apiUrl) {
    var error = "";

    // Configuración de la solicitud DELETE
    const requestOptions = {
        method: 'DELETE'
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        const data = await response.json();

        //console.log('Respuesta del servidor:', data);

        if (status != 200) {
            error = "Error:  " + data.mensaje;
        }

        // // Verificamos si la respuesta es exitosa (código de estado 2xx)
        // if (!response.ok) {
        //     throw new Error(`Error: ${response.status} - ${response.statusText}`);
        // }

        // Hacemos algo con la respuesta (puede no haber datos en una solicitud DELETE)
        //console.log('Recurso eliminado exitosamente');

    } catch (error) {
        error = error.message;
        // Manejamos cualquier error que pueda ocurrir durante la solicitud
        //console.error('Error en la solicitud DELETE:', error.message);
    }

    return error;
}



async function postProcess(apiUrl, dataToSend) {

    var data = {};

    // Configuración de la solicitud
    const requestOptions = {
        method: "POST",
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(dataToSend)
    };

    try {
        // Realizamos la solicitud fetch y esperamos la respuesta
        const response = await fetch(apiUrl, requestOptions);
        const status = response.status;
        data = await response.json();
        
        if (status != 200) {
            data.error = "Error:  " + data.mensaje;
        }
    } catch (error) {
        data.error = "Error: "  + error.message;
    }

    return data;
}