$(document).ready(function () {
    Cargar();

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    document.addEventListener('keydown', function (event) {
        if(event.keyCode == 74 && event.ctrlKey){
            event.preventDefault();
        }
    });

});


function Cargar() {

    var error = "";
    var datos = [];

    $.ajax({
        async: false,
        type: "GET",
        url: "/perfil",
        data: {
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
            datos = result.mensaje;

            if (datos.length > 0) {
                var dto = datos[0];
                $("#hfId").val(dto.id);
                $("#txtNit").val(dto.nit);
                $("#txtNombre").val(dto.nombre);
                $("#txtTelefono").val(dto.telefono);
                $("#txtEmail").val(dto.email);
                $("#txtDireccion").val(dto.direccion);

                $("#txtIva").val(dto.iva);
                $("#txtCiudad").val(dto.ciudad);
                $("#txtRegion").val(dto.region);
                $("#txtPostal").val(dto.postal);
                $("#txtTamanio").val(dto.tamanio);
                $("#txtSlogan").val(dto.slogan);

                if (dto.logo)
                    MostrarLogo(dto.logo);
            }

        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });
}

function MostrarVentana(texto) {

    $("#spTexto").text(texto);
    $('#myModal').modal('show');
}

function Almacenar() {

    var id = $("#hfId").val() == "" ? 0 : $("#hfId").val();

    if (id > 0)
        Actualizar();
    else
        Insertar();
}


function Insertar() {

    var nit = $("#txtNit").val().trim();
    var nombre = $("#txtNombre").val().trim();
    var telefono = $("#txtTelefono").val().trim();
    var email = $("#txtEmail").val().trim();
    var direccion = $("#txtDireccion").val().trim();
    var iva = $("#txtIva").val().trim();
    var ciudad = $("#txtCiudad").val().trim();
    var region = $("#txtRegion").val().trim();
    var postal = $("#txtPostal").val().trim();
    var tamanio = $("#txtTamanio").val().trim();
    var slogan = $("#txtSlogan").val().trim();
    var error = "";

    $.ajax({
        async: false,
        type: "POST",
        url: "/perfil",
        data: {
            nit: nit,
            nombre: nombre,
            direccion: direccion,
            telefono: telefono,
            email: email,
            iva: iva,
            ciudad: ciudad,
            region: region,
            postal: postal,
            tamanio: tamanio,
            slogan: slogan
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#nuevoCliente').modal('hide');
}


function Actualizar() {

    var id = $("#hfId").val();
    var nit = $("#txtNit").val().trim();
    var nombre = $("#txtNombre").val().trim();
    var telefono = $("#txtTelefono").val().trim();
    var email = $("#txtEmail").val().trim();
    var direccion = $("#txtDireccion").val().trim();
    var iva = $("#txtIva").val().trim();
    var ciudad = $("#txtCiudad").val().trim();
    var region = $("#txtRegion").val().trim();
    var postal = $("#txtPostal").val().trim();
    var tamanio = $("#txtTamanio").val().trim();
    var slogan = $("#txtSlogan").val().trim();
    var error = "";

    $.ajax({
        async: false,
        type: "PUT",
        url: "/perfil",
        data: {
            id: id,
            nit: nit,
            nombre: nombre,
            direccion: direccion,
            telefono: telefono,
            email: email,
            iva: iva,
            ciudad: ciudad,
            region: region,
            postal: postal,
            tamanio: tamanio,
            slogan: slogan
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#nuevoCliente').modal('hide');
}



function upload_image() {

    var id = $("#hfId").val();

    if (id == "") {
        MensajeError("Primero registre información de la empresa");
        return;
    }


    var inputFileImage = document.getElementById("file");
    var file = inputFileImage.files[0];

    if ((typeof file === "object") && (file !== null)) {
        $("#load_img").text('Cargando...');
        var data = new FormData();
        data.append('file', file);
        data.append('id', id);
        console.log(id);

        $.ajax({
            url: "perfil/upload",        // Url to which the request is send
            type: "POST",             // Type of request to be send, called as method
            data: data, 			  // Data sent to server, a set of key/value pairs (i.e. form fields and values)
            contentType: false,       // The content type used when sending data to the server.
            cache: false,             // To unable request pages to be cached
            processData: false,        // To send DOMDocument or non processed data file it is set to false
            success: function (data)   // A function to be called if request succeeds
            {
                if (data.error) {
                    MensajeError(data.error);
                    return;
                }

                MostrarLogo(data.ruta, 1);
            },
            error: function (errMsg) {
                alert(errMsg.responseText);
            },
        });

    }


}

function MostrarLogo(ruta, estado) {

    //$("#imgLogo").attr("src", data.ruta);
    var html = "<img class='img-responsive' id='imgLogo' src='" + ruta + "' alt='Logo'>";
    $("#load_img").html(html);

    if(estado > 0)
        MensajeExitoso("Logo actualizado");
}
