const db = require("../models");

exports.get = async function (req, res) {

    if (!req.query.id) return res.send({ error: "ingrese id" });

    var texto = req.query.id;
    var array = texto.split("-");

    if (array.length < 2) return res.send({ error: "ingrese id con formato correcto" });

    var id = array[0];
    var co = array[1];

    var fs = require('fs');
    var pdf = require("html-pdf");
    var ejs = require('ejs');

    var query = `select a.id_factura as id, b.nit, b.nombre, b.direccion, DATE_FORMAT(a.createdAt, '%d/%m/%Y %h:%m:%s')  as fecha, format(a.total, 2) as total, a.autorizacion, a.control
                from factura a
                inner join cliente b on a.id_cliente = b.id_cliente
                where id_factura = '${id}' and control = '${co}' `;

    var datos = await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            if (data.length == 0) return res.send({ error: "No existe factura con ese identificador" });
            return data[0];
        }).catch(err => {
            return null;
        });

    query = `select c.id_producto, b.cantidad as cantidad, concat(c.nombre, ' ', d.nombre) as descripcion, format(b.precio, 2) as precio, format(b.sub_total, 2)  as subtotal
        from factura a
        inner join detalle b on a.id_factura = b.id_factura
        inner join producto c on b.id_producto = c.id_producto
        inner join envase d on d.id_envase = c.id_envase
        where a.id_factura = '${id}' `;

    var detalles = await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return data;
        }).catch(err => {
            return null;
        });


    query = `select * from perfil `;

    var perfil = await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return data[0];
        }).catch(err => {
            return null;
        });

    var template = "./templates/factura.html";
    let logo = "./public" + perfil.logo;
    let base64 = fs.readFileSync(logo, { encoding: 'base64' });

    var qr = "http://bwipjs-api.metafloor.com/?bcid=qrcode&text=" + encodeURI(req.protocol + '://' + req.get('host') + '/qr?id=' + datos.id + '-' + datos.control);

    var empresa = {
        nombre: perfil.nombre,
        direccion: perfil.direccion,
        slogan: perfil.slogan,
        logo: "data:image/jpeg;base64," + base64,
        tamanio: perfil.tamanio,
        qr: qr
    };

    var encabezado = {
        id: datos.id,
        factura: "FACTURA " + datos.id,
        fecha: datos.fecha,
        nombre: datos.nombre,
        nit: datos.nit,
        direccion: datos.direccion,
        total: "TOTAL Q " + datos.total,
        certificado: datos.autorizacion
    };

    var html = await ejs.renderFile(template, { empresa: empresa, encabezado: encabezado, detalle: detalles }, { async: true });

    pdf.create(html).toBuffer(function (err, buffer) {
        if (err) return res.send({ error: err.message });
        var nombre = "factura-" + id + ".pdf";
        res.setHeader('Content-disposition', 'inline; filename=' + nombre);
        res.setHeader('Content-type', 'application/pdf');
        res.send(buffer);
    });

}