const db = require("../models");
const { upperCase } = require("upper-case");
const model = db.perfil;
const Op = db.Sequelize.Op;

var fs = require('fs');
var path = require('path');

exports.get = async function (req, res) {

    const id = req.params.id;
    //var condition = title ? { title: { [Op.like]: `%${title}%` } } : null;
    var condition = id ? { id: id } : null;

    await model.findAll({ where: condition, order: [['nombre', 'ASC']], })
        .then(data => {
            res.send({ mensaje: data });
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });
}

exports.findById = async function (req, res) {

    let id = req.params.id;
    await model.findAll({
        where: { id: id }
    })
};

exports.post = async function (req, res) {

    if (!req.body.nit) return res.send({ error: "ingrese nit" });
    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.slogan) return res.send({ error: "ingrese slogan" });
    if (!req.body.telefono) return res.send({ error: "ingrese telefono" });
    if (!req.body.direccion) return res.send({ error: "ingrese direccion" });
    if (!req.body.email) return res.send({ error: "ingrese email" });

    if (!req.body.iva) return res.send({ error: "ingrese iva" });
    if (isNaN(req.body.iva)) return res.send({ error: "ingrese valor numúmerico en iva" });
    if (!req.body.ciudad) return res.send({ error: "ingrese ciudad" });
    if (!req.body.region) return res.send({ error: "ingrese region" });
    if (!req.body.postal) return res.send({ error: "ingrese postal" });
    if (!req.body.tamanio) return res.send({ error: "ingrese tamaño" });
    if (isNaN(req.body.tamanio)) return res.send({ error: "ingrese valor numúmerico tamaño logo" });

    await model.create({
        //id: 0,
        nit: req.body.nit,
        nombre: req.body.nombre,
        telefono: req.body.telefono,
        direccion: req.body.direccion,
        email: req.body.email,
        moneda: "Q",
        iva: req.body.iva,
        simbolo: req.body.simbolo,
        ciudad: req.body.ciudad,
        region: req.body.region,
        postal: req.body.postal,
        estado: 1,
        logo: req.body.logo,
        tamanio: req.body.tamanio,
        slogan: req.body.slogan
    })
        .then(data => {
            res.send({ mensaje: "Registro almacenado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.put = async function (req, res) {

    if (!req.body.nit) return res.send({ error: "ingrese nit" });
    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.slogan) return res.send({ error: "ingrese slogan" });
    if (!req.body.telefono) return res.send({ error: "ingrese telefono" });
    if (!req.body.direccion) return res.send({ error: "ingrese direccion" });
    if (!req.body.email) return res.send({ error: "ingrese email" });

    if (!req.body.iva) return res.send({ error: "ingrese iva" });
    if (isNaN(req.body.iva)) return res.send({ error: "ingrese valor numúmerico en iva" });
    if (!req.body.ciudad) return res.send({ error: "ingrese ciudad" });
    if (!req.body.region) return res.send({ error: "ingrese region" });
    if (!req.body.postal) return res.send({ error: "ingrese postal" });
    if (!req.body.tamanio) return res.send({ error: "ingrese tamaño" });
    if (isNaN(req.body.tamanio)) return res.send({ error: "ingrese valor numúmerico tamaño logo" });
    if (!req.body.id) return res.send({ error: "ingrese id" });

    const id = req.body.id;

    await model.update(
        {
            nit: req.body.nit,
            nombre: req.body.nombre,
            telefono: req.body.telefono,
            direccion: req.body.direccion,
            email: req.body.email,
            iva: req.body.iva,
            simbolo: req.body.simbolo,
            ciudad: req.body.ciudad,
            region: req.body.region,
            postal: req.body.postal,
            estado: 1,
            logo: req.body.logo,
            tamanio: req.body.tamanio,
            slogan: req.body.slogan
        },
        {
            where: { id: id }
        }
    )
        .then(data => {
            res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.upload = async function (req, res) {

    var id = req.body.id;
    console.log(req.files);

    if (!req.files) return res.send({ error: "imagen no enviada" });
    if (!req.files.file) return res.send({ error: "parametro file no enviado" });

    var dto = req.files.file;
    var tipo = dto.type;
    var isWin = /^win/.test(process.platform);
    var array = isWin ? dto.path.split("\\") : dto.path.split("/");
    var index = array.length - 1;
    var ruta =  "/" + array[index - 1] + "/" + array[index];
    

    if (tipo != "image/jpeg" && tipo != "image/jpg" && tipo != "image/png") {

        fs.unlink(dto.path, function (err) {
            if (err) res.send({ error: "no eliminado" });
            return res.send({ error: "El archivo no es una imagen" });
        });
    }
    else {

        await model.update(
            {
                logo: ruta
            },
            {
                where: { id: id }
            }
        ).then(data => {
            res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
            .catch(err => {
                res.send(err);
            })

        return res.send({ ruta: ruta });
    }

};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });
    let id = req.body.id;

    await model.destroy({
        where: { id: id }
    })
        .then(data => {
            res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};