const db = require("../models");
const model = db.compra;
const producto = db.producto;
const Op = db.Sequelize.Op;


exports.get = async function (req, res) {

    const id = req.params.id;
    var condition = id ? { id_compra: id } : null;

    await model.findAll({ where: condition, order: [['id_compra', 'ASC']], })
        .then(data => {
            res.send({ mensaje: data, error: "" });
        })
        .catch(err => {
            res.status(500).send({ error: err.message || "Some error occurred while retrieving tutorials." });
        });
}

exports.findById = async function (req, res) {

    let id = req.params.id;
    await model.findAll({
        where: { id_compra: id }
    })
};

exports.post = async function (req, res) {

    if (!req.body.id_producto) return res.send({ error: "ingrese id_producto" });
    if (isNaN(req.body.id_producto)) return res.send({ error: "ingrese valor numúmerico en id_producto: " + req.body.id_producto });
    if (!req.body.costo) return res.send({ error: "ingrese costo" });
    if (isNaN(req.body.costo)) return res.send({ error: "ingrese valor numúmerico en costo: " + req.body.costo });
    if (!req.body.precio) return res.send({ error: "ingrese precio" });
    if (isNaN(req.body.precio)) return res.send({ error: "ingrese valor numúmerico en precio: " + req.body.precio });
    if (!req.body.cantidad) return res.send({ error: "ingrese cantidad" });
    if (isNaN(req.body.cantidad)) return res.send({ error: "ingrese valor numúmerico en cantidad: " + req.body.cantidad });
    if (req.body.cantidad == 0) return res.send({ error: "ingrese cantidad mayor a cero" });

    const t = await db.sequelize.transaction();

    var registros = await producto.findAll({ where: { id_producto: req.body.id_producto } })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros == 0)
        return res.send({ error: "No existe producto con ese identificador" });

    try {

        await model.create({
            id_producto: req.body.id_producto,
            costo: req.body.costo,
            precio: req.body.precio,
            cantidad: req.body.cantidad
        }, { transaction: t }); 

        var query = `update producto set existencia = existencia + ${req.body.cantidad}, precio = ${req.body.precio}, updatedAt = now() where id_producto = ` + req.body.id_producto;
        db.sequelize.query(query, { type: db.sequelize.QueryTypes.update }, { transaction: t });

        await t.commit();
        return res.send({ mensaje: "compra exitosa", error: "" });

    } catch (err) {
        await t.rollback();
        return res.send({ error: err.message });
    }
};


exports.put = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });

    var id = req.body.id;

    var registro = await model.findAll({ where: { id_compra: id } })
        .then(data => {
            return data[0];
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registro == null)
        return res.send({ error: "No existe producto con ese identificador" });

    if (req.body.costo) registro.costo = req.body.costo;
    if (req.body.precio) registro.precio = req.body.precio;
    if (req.body.cantidad) registro.cantidad = req.body.cantidad;

    await model.update(
        {
            id_producto: registro.id_producto,
            costo: registro.costo,
            precio: registro.precio,
            cantidad: registro.cantidad
        },
        {
            where: { id_compra: id }
        }
    )
        .then(data => {
            res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });
    if (isNaN(req.body.id)) return res.send({ error: "ingrese valor numúmerico en id: " + req.body.id });

    let id = req.body.id;
    await model.destroy({
        where: { id_compra: id }
    })
        .then(data => {
            res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};