const db = require("../models");
const model = db.cliente;
const factura = db.factura;
const Op = db.Sequelize.Op;


exports.get = async function (req, res) {

    var query = `select id_cliente, nombre, telefono, email, direccion, estado, nit,
                    case 
                        when nit = 'CF' then concat(upper(nit), '-', nombre) 
                        when nit != 'CF' then nit 
                    end as convertido
                    from cliente `;

    const id = req.params.id;

    if (id) query += ` where id_cliente = '${id}'  `;
    query += " order by convertido asc";

    await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return res.send({ mensaje: data, error: "" });
        }).catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    /*
     const id = req.params.id;
    //var condition = title ? { title: { [Op.like]: `%${title}%` } } : null;
    var condition = id ? { id: id } : null;

    model.findAll({ where: condition, order: [['nombre', 'ASC']], })
        .then(data => {
            res.send({ mensaje: data, error: "" });
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });
        */
}

exports.findById = function (req, res) {

    let id = req.params.id;
    model.findAll({
        where: { id: id }
    })
};

exports.post = async function (req, res) {

    if (!req.body.nit) return res.send({ error: "ingrese nit" });
    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    //if (!req.body.telefono) return res.send({ error: "ingrese telefono" });
    //if (!req.body.direccion) return res.send({ error: "ingrese direccion" });
    //if (!req.body.email) return res.send({ error: "ingrese email" });

    var nombre = req.body.nombre.toUpperCase();
    var nit = req.body.nit.toUpperCase();
    var condition = nit ? { nit: { [Op.like]: `%${nit}%` } } : null;

    if (nit.toUpperCase() == 'CF')
        condition = nit ? { nit: { [Op.like]: `%${nit}%` }, nombre: nombre } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe cliente con ese nit" });


    await model.create({
        //id: 0,
        nit: nit,
        nombre: nombre,
        telefono: req.body.telefono,
        direccion: req.body.direccion,
        email: req.body.email,
        estado: 1
    })
        .then(data => {
            res.send({ mensaje: "Registro almacenado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.put = async function (req, res) {

    if (!req.body.nit) return res.send({ error: "ingrese nit" });
    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    //if (!req.body.telefono) return res.send({ error: "ingrese telefono" });
    //if (!req.body.direccion) return res.send({ error: "ingrese direccion" });
    //if (!req.body.email) return res.send({ error: "ingrese email" });
    if (!req.body.id) return res.send({ error: "ingrese id" });

    const id = req.body.id;
    var nombre = req.body.nombre.toUpperCase();
    var nit = req.body.nit.toUpperCase();
    var condition = nit ? { nit: { [Op.like]: `%${nit}%` }, id_cliente: { [Op.not]: id } } : null;

    if (nit.toUpperCase() == 'CF')
        condition = nit ? { nit: { [Op.like]: `%${nit}%` }, nombre: nombre, id_cliente: { [Op.not]: id } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            return res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe cliente con ese nit" });

    await model.update(
        {
            nit: nit,
            nombre: req.body.nombre.toUpperCase(),
            telefono: req.body.telefono,
            direccion: req.body.direccion,
            email: req.body.email,
            estado: req.body.estado
        },
        {
            where: { id_cliente: id }
        }
    )
        .then(data => {
            res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });
    let id = req.body.id;

    var condition = id ? { id_cliente: id } : null;
    var registros = await factura.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "No es posible borrar un cliente cuando tiene facturas asociadas" });

    await model.destroy({
        where: { id_cliente: id }
    })
        .then(data => {
            res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.tipo = async function (req, res) {

    var query = `select 
    case when count(*) = 0 then 1 else 2 end as tipo
    from cliente 
    where upper(nit) = upper('c/f')
    and id_cliente = ` + req.body.id;

    await model.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return res.send(data[0]);
        }).catch(err => {
            return res.send(null);
        });
}
